/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.formatters;

import com.ibm.hwmca.fw.formatters.HexFormatter;
import com.ibm.hwmca.fw.util.CommonResourceBundle;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.IllegalUserDataException;

public class NCHexFormatter
extends HexFormatter {
    private static final String TRACE_MASKD = "XFRMHEXD";
    private static final String TRACE_MASKF = "XFRMHEXF";
    private static final String TRACE_MASKT = "XFRMHEXT";
    protected int padsize = 0;
    protected LocalizableText invalidValueMsg = new LocalizableText(CommonResourceBundle.getBundleName(), "formatter.badvalue", null);
    protected LocalizableText invalidLengthMsg = new LocalizableText(CommonResourceBundle.getBundleName(), "formatter.badlength", null);
    protected LocalizableText msgTitle = new LocalizableText(CommonResourceBundle.getBundleName(), "formatter.title", null);

    public String format(Object obj) {
        String intString = "";
        try {
            intString = (String)obj;
            Trace.trace(TRACE_MASKF, "Here in format of NCHexFormatter initial string is " + intString);
            if (this.padsize > 0 && intString.length() < this.padsize) {
                while (intString.length() < this.padsize) {
                    intString = "0" + intString;
                }
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Error converting '" + obj + "' to a long, defaulting to 0");
            intString = "0";
        }
        intString = intString.toUpperCase();
        Trace.trace(TRACE_MASKF, "about to return from NCHexFormatter with " + intString);
        return intString;
    }

    public Object parse(String source) throws IllegalUserDataException {
        long retVal = 0L;
        if (this.padsize > 0 && source.length() > this.padsize) {
            throw new IllegalUserDataException(this.invalidLengthMsg.toString());
        }
        try {
            retVal = Long.parseLong(source, 16);
        }
        catch (NumberFormatException e) {
            throw new IllegalUserDataException(this.invalidValueMsg.toString());
        }
        return source;
    }
}

